package k.docker.models

import k.common.low
import k.serializing.Optional

class HealthCheck(@Optional("NONE")
                  val cmd : String = "NONE",
                  @Optional("1s")
                  val startPeriod : String = "1s",
                  @Optional("1")
                  val retries : Int = 1,
                  @Optional("1s")
                  val interval : String = "1s",
                  @Optional("1s")
                  val timeout : String = "1s") {
    val enabled
        get() = cmd.isNotBlank() && cmd.low != "none"

    val asParams
        get() = if (enabled)
            " --health-cmd '$cmd' --health-start-period $startPeriod --health-timeout $timeout --health-interval $interval --health-retries $retries "
        else
            " --no-healthcheck "

    val normalized
        get() = if (enabled)
            this
        else
            HealthCheck()
}