package k.docker.models

import k.common.*

val String.image : Image
    get() {
        val tag = this.substringAfter("/") default this

        return Image(this extract "(.*?)/" default "",
                     tag extract "([^:]*)" default tag,
                     tag extract ":(.*)" default "latest")
    }

data class Image(val registry : String,
                 val name : String,
                 val version : String) {
    val fullName
        get() = "${registry.str.low merge "/"}${name.low}${":" and version}"

    override fun toString() =
        fullName
}