package k.docker.models

import k.common.low
import k.serializing.Optional

class Logging(@Optional("0")
              val maxFile : Int = 0,
              @Optional("json-file")
              val driver : String = "json-file",
              @Optional("10M")
              val maxSize : String = "10M") {
    val enabled
        get() = maxFile > 0 && driver.isNotBlank() && driver.low != "none"

    val asParams
        get() = if (enabled)
            " --log-driver $driver --log-opt max-file=$maxFile --log-opt max-size=$maxSize "
        else
            " --log-driver none "

    val normalized
        get() = if (enabled)
            this
        else
            Logging()
}