package k.docker.models

import k.common.ParamList
import k.serializing.Optional

class NetworkParams(val Id : String,
                    val Name : String,
                    val Attachable : Boolean,
                    val Driver : String,
                    val Scope : String,
                    @Optional
                    val IPAM : Ipam,
                    @Optional
                    val Labels : ParamList,
                    @Optional
                    val Containers : Map<String, Container>,
                    @Optional
                    val Options : ParamList)
{
    class Container(val Name : String)

    class Ipam(@Optional
               val Config : List<IpamConfigItem>)

    class IpamConfigItem(@Optional
                         val Subnet : String,
                         @Optional
                         val Gateway : String)
}