package k.docker.models

import k.common.ParamList
import k.serializing.*
import k.serializing.Optional
import java.util.*

class ServiceParams(val ID : String,
                    val Spec : ServiceSpec,
                    @Format("ISO8601-OFFSET")
                    val CreatedAt : Date,
                    @Format("ISO8601-OFFSET")
                    val UpdatedAt : Date,
                    @Optional
                    val Endpoint : SrvEndpoint) {
    class ServiceMode(@Optional
                      val Replicated : Replicated)

    class Replicated(val Replicas : Int = 1)

    class ServiceSpec(val Name : String,
                      val TaskTemplate : TaskTemplate,
                      val Mode : ServiceMode,
                      @Optional
                      val Labels : ParamList,
                      @Optional
                      val UpdateConfig : UpdateConfigParams)

    class TaskTemplate(val ContainerSpec : ContainerSpec,
                       @Optional
                       val Networks : List<Network>,
                       @Optional
                       val LogDriver : LogDriverParams)

    class Mount(val Type : String,
                val Source : String,
                val Target : String)

    class Network(val Target : String)

    class ContainerSpec(@Optional
                        val Image : String,
                        @Optional
                        val Args : List<String>,
                        @Optional
                        val Env : List<String>,
                        @Optional
                        val Mounts : List<Mount>,
                        @Optional
                        val Labels : ParamList,
                        @Optional
                        val Sysctls : ParamList,
                        @Optional
                        val Healthcheck : HealthcheckParams,
                        @Optional
                        val Secrets : List<SecretParams>)

    class UpdateConfigParams(@Optional("0")
                             val Delay : Long)

    class SecretParams(val SecretName : String)

    class LogDriverParams(@Optional
                          val Name : String = "",
                          @Optional
                          val Options : LogDriverOptions = LogDriverOptions())

    class LogDriverOptions(@Optional
                           @Name("max-file")
                           val maxFile : String = "",
                           @Optional
                           @Name("max-size")
                           val maxSize : String = "")

    class HealthcheckParams(@Optional
                            val Test : List<String> = listOf(),
                            @Optional("0")
                            val Interval : Long = 0,
                            @Optional("0")
                            val Timeout : Long = 0,
                            @Optional("0")
                            val Retries : Int = 0,
                            @Optional("0")
                            val StartPeriod : Long = 0)

    class SrvEndpoint(@Optional
                      val Ports : List<Port>)

    class Port(val TargetPort : Int,
               val PublishedPort : Int,
               val Protocol : String)
}