package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.GameVersionFeatureValue
import ru.pixnews.igdbclient.scheme.`field`.GameVersionFeatureValueField

private val _gameVersionFeatureValueFieldDslInstance: GameVersionFeatureValueFieldDsl =
    GameVersionFeatureValueFieldDsl()

public val GameVersionFeatureValue.Companion.`field`: GameVersionFeatureValueFieldDsl
  get() = _gameVersionFeatureValueFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [GameVersionFeatureValue] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#game-version-feature-value](https://api-docs.igdb.com/#game-version-feature-value)
 */
@IgdbClientDsl
public class GameVersionFeatureValueFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<GameVersionFeatureValueField, GameVersionFeatureValue>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [GameVersionFeatureValue] Igdb entity.
   *
   *  The value will be returned in the [GameVersionFeatureValue.id] field of the response
   */
  public val id: IgdbRequestField<GameVersionFeatureValue>
    get() = fieldWithId(GameVersionFeatureValueField.ID)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameVersionFeatureValueField.GAME))

  /**
   *  Fields of the "game_feature"
   * ([GameVersionFeature][ru.pixnews.igdbclient.model.GameVersionFeature]) nested IGDB entity
   */
  public val game_feature: GameVersionFeatureFieldDsl
    get() = GameVersionFeatureFieldDsl(fieldWithId(GameVersionFeatureValueField.GAME_FEATURE))

  /**
   *  Query for the "included_feature" field of the [GameVersionFeatureValue] Igdb entity.
   *
   *  The value will be returned in the [GameVersionFeatureValue.included_feature] field of the
   * response
   */
  public val included_feature: IgdbRequestField<GameVersionFeatureValue>
    get() = fieldWithId(GameVersionFeatureValueField.INCLUDED_FEATURE)

  /**
   *  Query for the "note" field of the [GameVersionFeatureValue] Igdb entity.
   *
   *  The value will be returned in the [GameVersionFeatureValue.note] field of the response
   */
  public val note: IgdbRequestField<GameVersionFeatureValue>
    get() = fieldWithId(GameVersionFeatureValueField.NOTE)

  /**
   *  Query for the "checksum" field of the [GameVersionFeatureValue] Igdb entity.
   *
   *  The value will be returned in the [GameVersionFeatureValue.checksum] field of the response
   */
  public val checksum: IgdbRequestField<GameVersionFeatureValue>
    get() = fieldWithId(GameVersionFeatureValueField.CHECKSUM)
}
