package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Platform
import ru.pixnews.igdbclient.scheme.`field`.PlatformField

private val _platformFieldDslInstance: PlatformFieldDsl = PlatformFieldDsl()

public val Platform.Companion.`field`: PlatformFieldDsl
  get() = _platformFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Platform] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#platform](https://api-docs.igdb.com/#platform)
 */
@IgdbClientDsl
public class PlatformFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<PlatformField, Platform>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.id] field of the response
   */
  public val id: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.ID)

  /**
   *  Query for the "abbreviation" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.abbreviation] field of the response
   */
  public val abbreviation: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.ABBREVIATION)

  /**
   *  Query for the "alternative_name" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.alternative_name] field of the response
   */
  public val alternative_name: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.ALTERNATIVE_NAME)

  /**
   *  Query for the "category" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.category] field of the response
   */
  public val category: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.CATEGORY)

  /**
   *  Query for the "created_at" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.CREATED_AT)

  /**
   *  Query for the "generation" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.generation] field of the response
   */
  public val generation: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.GENERATION)

  /**
   *  Query for the "name" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.name] field of the response
   */
  public val name: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.NAME)

  /**
   *  Fields of the "platform_logo" ([PlatformLogo][ru.pixnews.igdbclient.model.PlatformLogo])
   * nested IGDB entity
   */
  public val platform_logo: PlatformLogoFieldDsl
    get() = PlatformLogoFieldDsl(fieldWithId(PlatformField.PLATFORM_LOGO))

  /**
   *  Fields of the "platform_family" ([PlatformFamily][ru.pixnews.igdbclient.model.PlatformFamily])
   * nested IGDB entity
   */
  public val platform_family: PlatformFamilyFieldDsl
    get() = PlatformFamilyFieldDsl(fieldWithId(PlatformField.PLATFORM_FAMILY))

  /**
   *  Query for the "slug" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.slug] field of the response
   */
  public val slug: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.SLUG)

  /**
   *  Query for the "summary" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.summary] field of the response
   */
  public val summary: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.SUMMARY)

  /**
   *  Query for the "updated_at" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.url] field of the response
   */
  public val url: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.URL)

  /**
   *  Fields of the "versions" ([PlatformVersion][ru.pixnews.igdbclient.model.PlatformVersion])
   * nested IGDB entity
   */
  public val versions: PlatformVersionFieldDsl
    get() = PlatformVersionFieldDsl(fieldWithId(PlatformField.VERSIONS))

  /**
   *  Fields of the "websites" ([PlatformWebsite][ru.pixnews.igdbclient.model.PlatformWebsite])
   * nested IGDB entity
   */
  public val websites: PlatformWebsiteFieldDsl
    get() = PlatformWebsiteFieldDsl(fieldWithId(PlatformField.WEBSITES))

  /**
   *  Query for the "checksum" field of the [Platform] Igdb entity.
   *
   *  The value will be returned in the [Platform.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Platform>
    get() = fieldWithId(PlatformField.CHECKSUM)
}
