package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.PlayerPerspective
import ru.pixnews.igdbclient.scheme.`field`.PlayerPerspectiveField

private val _playerPerspectiveFieldDslInstance: PlayerPerspectiveFieldDsl =
    PlayerPerspectiveFieldDsl()

public val PlayerPerspective.Companion.`field`: PlayerPerspectiveFieldDsl
  get() = _playerPerspectiveFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [PlayerPerspective] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#player-perspective](https://api-docs.igdb.com/#player-perspective)
 */
@IgdbClientDsl
public class PlayerPerspectiveFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<PlayerPerspectiveField, PlayerPerspective>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [PlayerPerspective] Igdb entity.
   *
   *  The value will be returned in the [PlayerPerspective.id] field of the response
   */
  public val id: IgdbRequestField<PlayerPerspective>
    get() = fieldWithId(PlayerPerspectiveField.ID)

  /**
   *  Query for the "created_at" field of the [PlayerPerspective] Igdb entity.
   *
   *  The value will be returned in the [PlayerPerspective.created_at] field of the response
   */
  public val created_at: IgdbRequestField<PlayerPerspective>
    get() = fieldWithId(PlayerPerspectiveField.CREATED_AT)

  /**
   *  Query for the "name" field of the [PlayerPerspective] Igdb entity.
   *
   *  The value will be returned in the [PlayerPerspective.name] field of the response
   */
  public val name: IgdbRequestField<PlayerPerspective>
    get() = fieldWithId(PlayerPerspectiveField.NAME)

  /**
   *  Query for the "slug" field of the [PlayerPerspective] Igdb entity.
   *
   *  The value will be returned in the [PlayerPerspective.slug] field of the response
   */
  public val slug: IgdbRequestField<PlayerPerspective>
    get() = fieldWithId(PlayerPerspectiveField.SLUG)

  /**
   *  Query for the "updated_at" field of the [PlayerPerspective] Igdb entity.
   *
   *  The value will be returned in the [PlayerPerspective.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<PlayerPerspective>
    get() = fieldWithId(PlayerPerspectiveField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [PlayerPerspective] Igdb entity.
   *
   *  The value will be returned in the [PlayerPerspective.url] field of the response
   */
  public val url: IgdbRequestField<PlayerPerspective>
    get() = fieldWithId(PlayerPerspectiveField.URL)

  /**
   *  Query for the "checksum" field of the [PlayerPerspective] Igdb entity.
   *
   *  The value will be returned in the [PlayerPerspective.checksum] field of the response
   */
  public val checksum: IgdbRequestField<PlayerPerspective>
    get() = fieldWithId(PlayerPerspectiveField.CHECKSUM)
}
