package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.AlternativeName
import ru.pixnews.igdbclient.scheme.`field`.AlternativeNameField

private val _alternativeNameFieldDslInstance: AlternativeNameFieldDsl = AlternativeNameFieldDsl()

public val AlternativeName.Companion.`field`: AlternativeNameFieldDsl
  get() = _alternativeNameFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [AlternativeName] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#alternative-name](https://api-docs.igdb.com/#alternative-name)
 */
@IgdbClientDsl
public class AlternativeNameFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<AlternativeNameField, AlternativeName>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [AlternativeName] Igdb entity.
   *
   *  The value will be returned in the [AlternativeName.id] field of the response
   */
  public val id: IgdbRequestField<AlternativeName>
    get() = fieldWithId(AlternativeNameField.ID)

  /**
   *  Query for the "comment" field of the [AlternativeName] Igdb entity.
   *
   *  The value will be returned in the [AlternativeName.comment] field of the response
   */
  public val comment: IgdbRequestField<AlternativeName>
    get() = fieldWithId(AlternativeNameField.COMMENT)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(AlternativeNameField.GAME))

  /**
   *  Query for the "name" field of the [AlternativeName] Igdb entity.
   *
   *  The value will be returned in the [AlternativeName.name] field of the response
   */
  public val name: IgdbRequestField<AlternativeName>
    get() = fieldWithId(AlternativeNameField.NAME)

  /**
   *  Query for the "checksum" field of the [AlternativeName] Igdb entity.
   *
   *  The value will be returned in the [AlternativeName.checksum] field of the response
   */
  public val checksum: IgdbRequestField<AlternativeName>
    get() = fieldWithId(AlternativeNameField.CHECKSUM)
}
