package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Company
import ru.pixnews.igdbclient.scheme.`field`.CompanyField

private val _companyFieldDslInstance: CompanyFieldDsl = CompanyFieldDsl()

public val Company.Companion.`field`: CompanyFieldDsl
  get() = _companyFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Company] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#company](https://api-docs.igdb.com/#company)
 */
@IgdbClientDsl
public class CompanyFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CompanyField, Company>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.id] field of the response
   */
  public val id: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.ID)

  /**
   *  Query for the "change_date" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.change_date] field of the response
   */
  public val change_date: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.CHANGE_DATE)

  /**
   *  Query for the "change_date_category" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.change_date_category] field of the response
   */
  public val change_date_category: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.CHANGE_DATE_CATEGORY)

  /**
   *  Fields of the "changed_company_id" ([Company][Company]) nested IGDB entity
   */
  public val changed_company_id: CompanyFieldDsl
    get() = CompanyFieldDsl(fieldWithId(CompanyField.CHANGED_COMPANY_ID))

  /**
   *  Query for the "country" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.country] field of the response
   */
  public val country: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.COUNTRY)

  /**
   *  Query for the "created_at" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.CREATED_AT)

  /**
   *  Query for the "description" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.description] field of the response
   */
  public val description: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.DESCRIPTION)

  /**
   *  Fields of the "developed" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val developed: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(CompanyField.DEVELOPED))

  /**
   *  Fields of the "logo" ([CompanyLogo][ru.pixnews.igdbclient.model.CompanyLogo]) nested IGDB
   * entity
   */
  public val logo: CompanyLogoFieldDsl
    get() = CompanyLogoFieldDsl(fieldWithId(CompanyField.LOGO))

  /**
   *  Query for the "name" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.name] field of the response
   */
  public val name: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.NAME)

  /**
   *  Fields of the "parent" ([Company][Company]) nested IGDB entity
   */
  public val parent: CompanyFieldDsl
    get() = CompanyFieldDsl(fieldWithId(CompanyField.PARENT))

  /**
   *  Fields of the "published" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val published: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(CompanyField.PUBLISHED))

  /**
   *  Query for the "slug" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.slug] field of the response
   */
  public val slug: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.SLUG)

  /**
   *  Query for the "start_date" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.start_date] field of the response
   */
  public val start_date: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.START_DATE)

  /**
   *  Query for the "start_date_category" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.start_date_category] field of the response
   */
  public val start_date_category: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.START_DATE_CATEGORY)

  /**
   *  Query for the "updated_at" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.url] field of the response
   */
  public val url: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.URL)

  /**
   *  Fields of the "websites" ([CompanyWebsite][ru.pixnews.igdbclient.model.CompanyWebsite]) nested
   * IGDB entity
   */
  public val websites: CompanyWebsiteFieldDsl
    get() = CompanyWebsiteFieldDsl(fieldWithId(CompanyField.WEBSITES))

  /**
   *  Query for the "checksum" field of the [Company] Igdb entity.
   *
   *  The value will be returned in the [Company.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Company>
    get() = fieldWithId(CompanyField.CHECKSUM)
}
