package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Franchise
import ru.pixnews.igdbclient.scheme.`field`.FranchiseField

private val _franchiseFieldDslInstance: FranchiseFieldDsl = FranchiseFieldDsl()

public val Franchise.Companion.`field`: FranchiseFieldDsl
  get() = _franchiseFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Franchise] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#franchise](https://api-docs.igdb.com/#franchise)
 */
@IgdbClientDsl
public class FranchiseFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<FranchiseField, Franchise>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Franchise] Igdb entity.
   *
   *  The value will be returned in the [Franchise.id] field of the response
   */
  public val id: IgdbRequestField<Franchise>
    get() = fieldWithId(FranchiseField.ID)

  /**
   *  Query for the "created_at" field of the [Franchise] Igdb entity.
   *
   *  The value will be returned in the [Franchise.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Franchise>
    get() = fieldWithId(FranchiseField.CREATED_AT)

  /**
   *  Fields of the "games" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val games: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(FranchiseField.GAMES))

  /**
   *  Query for the "name" field of the [Franchise] Igdb entity.
   *
   *  The value will be returned in the [Franchise.name] field of the response
   */
  public val name: IgdbRequestField<Franchise>
    get() = fieldWithId(FranchiseField.NAME)

  /**
   *  Query for the "slug" field of the [Franchise] Igdb entity.
   *
   *  The value will be returned in the [Franchise.slug] field of the response
   */
  public val slug: IgdbRequestField<Franchise>
    get() = fieldWithId(FranchiseField.SLUG)

  /**
   *  Query for the "updated_at" field of the [Franchise] Igdb entity.
   *
   *  The value will be returned in the [Franchise.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Franchise>
    get() = fieldWithId(FranchiseField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [Franchise] Igdb entity.
   *
   *  The value will be returned in the [Franchise.url] field of the response
   */
  public val url: IgdbRequestField<Franchise>
    get() = fieldWithId(FranchiseField.URL)

  /**
   *  Query for the "checksum" field of the [Franchise] Igdb entity.
   *
   *  The value will be returned in the [Franchise.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Franchise>
    get() = fieldWithId(FranchiseField.CHECKSUM)
}
