package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.TestDummy
import ru.pixnews.igdbclient.scheme.`field`.TestDummyField

private val _testDummyFieldDslInstance: TestDummyFieldDsl = TestDummyFieldDsl()

public val TestDummy.Companion.`field`: TestDummyFieldDsl
  get() = _testDummyFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [TestDummy] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#test-dummy](https://api-docs.igdb.com/#test-dummy)
 */
@IgdbClientDsl
public class TestDummyFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<TestDummyField, TestDummy>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.id] field of the response
   */
  public val id: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.ID)

  /**
   *  Query for the "bool_value" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.bool_value] field of the response
   */
  public val bool_value: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.BOOL_VALUE)

  /**
   *  Query for the "created_at" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.created_at] field of the response
   */
  public val created_at: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.CREATED_AT)

  /**
   *  Query for the "enum_test" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.enum_test] field of the response
   */
  public val enum_test: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.ENUM_TEST)

  /**
   *  Query for the "float_value" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.float_value] field of the response
   */
  public val float_value: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.FLOAT_VALUE)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(TestDummyField.GAME))

  /**
   *  Query for the "integer_array" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.integer_array] field of the response
   */
  public val integer_array: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.INTEGER_ARRAY)

  /**
   *  Query for the "integer_value" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.integer_value] field of the response
   */
  public val integer_value: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.INTEGER_VALUE)

  /**
   *  Query for the "name" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.name] field of the response
   */
  public val name: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.NAME)

  /**
   *  Query for the "new_integer_value" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.new_integer_value] field of the response
   */
  public val new_integer_value: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.NEW_INTEGER_VALUE)

  /**
   *  Query for the "private" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.`private`] field of the response
   */
  public val `private`: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.PRIVATE)

  /**
   *  Query for the "slug" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.slug] field of the response
   */
  public val slug: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.SLUG)

  /**
   *  Query for the "string_array" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.string_array] field of the response
   */
  public val string_array: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.STRING_ARRAY)

  /**
   *  Fields of the "test_dummies" ([TestDummy][TestDummy]) nested IGDB entity
   */
  public val test_dummies: TestDummyFieldDsl
    get() = TestDummyFieldDsl(fieldWithId(TestDummyField.TEST_DUMMIES))

  /**
   *  Fields of the "test_dummy" ([TestDummy][TestDummy]) nested IGDB entity
   */
  public val test_dummy: TestDummyFieldDsl
    get() = TestDummyFieldDsl(fieldWithId(TestDummyField.TEST_DUMMY))

  /**
   *  Query for the "updated_at" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.url] field of the response
   */
  public val url: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.URL)

  /**
   *  Query for the "checksum" field of the [TestDummy] Igdb entity.
   *
   *  The value will be returned in the [TestDummy.checksum] field of the response
   */
  public val checksum: IgdbRequestField<TestDummy>
    get() = fieldWithId(TestDummyField.CHECKSUM)
}
