package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.CollectionRelation

/**
 *  Fields of the [CollectionRelation] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#collection-relation](https://api-docs.igdb.com/#collection-relation)
 */
public enum class CollectionRelationField(
  public override val igdbName: String,
) : IgdbField<CollectionRelation> {
  /**
   *  Field "id" of the [CollectionRelation] IGDB entity. Matches [CollectionRelation.id].
   */
  ID("id"),
  /**
   *  Field "child_collection" of the [CollectionRelation] IGDB entity. Matches
   * [CollectionRelation.child_collection].
   */
  CHILD_COLLECTION("child_collection"),
  /**
   *  Field "parent_collection" of the [CollectionRelation] IGDB entity. Matches
   * [CollectionRelation.parent_collection].
   */
  PARENT_COLLECTION("parent_collection"),
  /**
   *  Field "type" of the [CollectionRelation] IGDB entity. Matches [CollectionRelation.type].
   */
  TYPE("type"),
  /**
   *  Field "updated_at" of the [CollectionRelation] IGDB entity. Matches
   * [CollectionRelation.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "created_at" of the [CollectionRelation] IGDB entity. Matches
   * [CollectionRelation.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "checksum" of the [CollectionRelation] IGDB entity. Matches
   * [CollectionRelation.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
