package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.CollectionRelationType

/**
 *  Fields of the [CollectionRelationType] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#collection-relation-type](https://api-docs.igdb.com/#collection-relation-type)
 */
public enum class CollectionRelationTypeField(
  public override val igdbName: String,
) : IgdbField<CollectionRelationType> {
  /**
   *  Field "id" of the [CollectionRelationType] IGDB entity. Matches [CollectionRelationType.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [CollectionRelationType] IGDB entity. Matches
   * [CollectionRelationType.name].
   */
  NAME("name"),
  /**
   *  Field "description" of the [CollectionRelationType] IGDB entity. Matches
   * [CollectionRelationType.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "allowed_child_type" of the [CollectionRelationType] IGDB entity. Matches
   * [CollectionRelationType.allowed_child_type].
   */
  ALLOWED_CHILD_TYPE("allowed_child_type"),
  /**
   *  Field "allowed_parent_type" of the [CollectionRelationType] IGDB entity. Matches
   * [CollectionRelationType.allowed_parent_type].
   */
  ALLOWED_PARENT_TYPE("allowed_parent_type"),
  /**
   *  Field "updated_at" of the [CollectionRelationType] IGDB entity. Matches
   * [CollectionRelationType.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "created_at" of the [CollectionRelationType] IGDB entity. Matches
   * [CollectionRelationType.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "checksum" of the [CollectionRelationType] IGDB entity. Matches
   * [CollectionRelationType.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
