package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.GameEngine

/**
 *  Fields of the [GameEngine] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-engine](https://api-docs.igdb.com/#game-engine)
 */
public enum class GameEngineField(
  public override val igdbName: String,
) : IgdbField<GameEngine> {
  /**
   *  Field "id" of the [GameEngine] IGDB entity. Matches [GameEngine.id].
   */
  ID("id"),
  /**
   *  Field "companies" of the [GameEngine] IGDB entity. Matches [GameEngine.companies].
   */
  COMPANIES("companies"),
  /**
   *  Field "created_at" of the [GameEngine] IGDB entity. Matches [GameEngine.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "description" of the [GameEngine] IGDB entity. Matches [GameEngine.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "logo" of the [GameEngine] IGDB entity. Matches [GameEngine.logo].
   */
  LOGO("logo"),
  /**
   *  Field "name" of the [GameEngine] IGDB entity. Matches [GameEngine.name].
   */
  NAME("name"),
  /**
   *  Field "platforms" of the [GameEngine] IGDB entity. Matches [GameEngine.platforms].
   */
  PLATFORMS("platforms"),
  /**
   *  Field "slug" of the [GameEngine] IGDB entity. Matches [GameEngine.slug].
   */
  SLUG("slug"),
  /**
   *  Field "updated_at" of the [GameEngine] IGDB entity. Matches [GameEngine.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [GameEngine] IGDB entity. Matches [GameEngine.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [GameEngine] IGDB entity. Matches [GameEngine.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
