package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Game

/**
 *  Fields of the [Game] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game](https://api-docs.igdb.com/#game)
 */
public enum class GameField(
  public override val igdbName: String,
) : IgdbField<Game> {
  /**
   *  Field "id" of the [Game] IGDB entity. Matches [Game.id].
   */
  ID("id"),
  /**
   *  Field "age_ratings" of the [Game] IGDB entity. Matches [Game.age_ratings].
   */
  AGE_RATINGS("age_ratings"),
  /**
   *  Field "aggregated_rating" of the [Game] IGDB entity. Matches [Game.aggregated_rating].
   */
  AGGREGATED_RATING("aggregated_rating"),
  /**
   *  Field "aggregated_rating_count" of the [Game] IGDB entity. Matches
   * [Game.aggregated_rating_count].
   */
  AGGREGATED_RATING_COUNT("aggregated_rating_count"),
  /**
   *  Field "alternative_names" of the [Game] IGDB entity. Matches [Game.alternative_names].
   */
  ALTERNATIVE_NAMES("alternative_names"),
  /**
   *  Field "artworks" of the [Game] IGDB entity. Matches [Game.artworks].
   */
  ARTWORKS("artworks"),
  /**
   *  Field "bundles" of the [Game] IGDB entity. Matches [Game.bundles].
   */
  BUNDLES("bundles"),
  /**
   *  Field "category" of the [Game] IGDB entity. Matches [Game.category].
   */
  CATEGORY("category"),
  /**
   *  Field "collection" of the [Game] IGDB entity. Matches [Game.collection].
   */
  COLLECTION("collection"),
  /**
   *  Field "cover" of the [Game] IGDB entity. Matches [Game.cover].
   */
  COVER("cover"),
  /**
   *  Field "created_at" of the [Game] IGDB entity. Matches [Game.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "dlcs" of the [Game] IGDB entity. Matches [Game.dlcs].
   */
  DLCS("dlcs"),
  /**
   *  Field "expansions" of the [Game] IGDB entity. Matches [Game.expansions].
   */
  EXPANSIONS("expansions"),
  /**
   *  Field "external_games" of the [Game] IGDB entity. Matches [Game.external_games].
   */
  EXTERNAL_GAMES("external_games"),
  /**
   *  Field "first_release_date" of the [Game] IGDB entity. Matches [Game.first_release_date].
   */
  FIRST_RELEASE_DATE("first_release_date"),
  /**
   *  Field "follows" of the [Game] IGDB entity. Matches [Game.follows].
   */
  FOLLOWS("follows"),
  /**
   *  Field "franchise" of the [Game] IGDB entity. Matches [Game.franchise].
   */
  FRANCHISE("franchise"),
  /**
   *  Field "franchises" of the [Game] IGDB entity. Matches [Game.franchises].
   */
  FRANCHISES("franchises"),
  /**
   *  Field "game_engines" of the [Game] IGDB entity. Matches [Game.game_engines].
   */
  GAME_ENGINES("game_engines"),
  /**
   *  Field "game_modes" of the [Game] IGDB entity. Matches [Game.game_modes].
   */
  GAME_MODES("game_modes"),
  /**
   *  Field "genres" of the [Game] IGDB entity. Matches [Game.genres].
   */
  GENRES("genres"),
  /**
   *  Field "hypes" of the [Game] IGDB entity. Matches [Game.hypes].
   */
  HYPES("hypes"),
  /**
   *  Field "involved_companies" of the [Game] IGDB entity. Matches [Game.involved_companies].
   */
  INVOLVED_COMPANIES("involved_companies"),
  /**
   *  Field "keywords" of the [Game] IGDB entity. Matches [Game.keywords].
   */
  KEYWORDS("keywords"),
  /**
   *  Field "multiplayer_modes" of the [Game] IGDB entity. Matches [Game.multiplayer_modes].
   */
  MULTIPLAYER_MODES("multiplayer_modes"),
  /**
   *  Field "name" of the [Game] IGDB entity. Matches [Game.name].
   */
  NAME("name"),
  /**
   *  Field "parent_game" of the [Game] IGDB entity. Matches [Game.parent_game].
   */
  PARENT_GAME("parent_game"),
  /**
   *  Field "platforms" of the [Game] IGDB entity. Matches [Game.platforms].
   */
  PLATFORMS("platforms"),
  /**
   *  Field "player_perspectives" of the [Game] IGDB entity. Matches [Game.player_perspectives].
   */
  PLAYER_PERSPECTIVES("player_perspectives"),
  /**
   *  Field "rating" of the [Game] IGDB entity. Matches [Game.rating].
   */
  RATING("rating"),
  /**
   *  Field "rating_count" of the [Game] IGDB entity. Matches [Game.rating_count].
   */
  RATING_COUNT("rating_count"),
  /**
   *  Field "release_dates" of the [Game] IGDB entity. Matches [Game.release_dates].
   */
  RELEASE_DATES("release_dates"),
  /**
   *  Field "screenshots" of the [Game] IGDB entity. Matches [Game.screenshots].
   */
  SCREENSHOTS("screenshots"),
  /**
   *  Field "similar_games" of the [Game] IGDB entity. Matches [Game.similar_games].
   */
  SIMILAR_GAMES("similar_games"),
  /**
   *  Field "slug" of the [Game] IGDB entity. Matches [Game.slug].
   */
  SLUG("slug"),
  /**
   *  Field "standalone_expansions" of the [Game] IGDB entity. Matches [Game.standalone_expansions].
   */
  STANDALONE_EXPANSIONS("standalone_expansions"),
  /**
   *  Field "status" of the [Game] IGDB entity. Matches [Game.status].
   */
  STATUS("status"),
  /**
   *  Field "storyline" of the [Game] IGDB entity. Matches [Game.storyline].
   */
  STORYLINE("storyline"),
  /**
   *  Field "summary" of the [Game] IGDB entity. Matches [Game.summary].
   */
  SUMMARY("summary"),
  /**
   *  Field "tags" of the [Game] IGDB entity. Matches [Game.tags].
   */
  TAGS("tags"),
  /**
   *  Field "themes" of the [Game] IGDB entity. Matches [Game.themes].
   */
  THEMES("themes"),
  /**
   *  Field "total_rating" of the [Game] IGDB entity. Matches [Game.total_rating].
   */
  TOTAL_RATING("total_rating"),
  /**
   *  Field "total_rating_count" of the [Game] IGDB entity. Matches [Game.total_rating_count].
   */
  TOTAL_RATING_COUNT("total_rating_count"),
  /**
   *  Field "updated_at" of the [Game] IGDB entity. Matches [Game.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [Game] IGDB entity. Matches [Game.url].
   */
  URL("url"),
  /**
   *  Field "version_parent" of the [Game] IGDB entity. Matches [Game.version_parent].
   */
  VERSION_PARENT("version_parent"),
  /**
   *  Field "version_title" of the [Game] IGDB entity. Matches [Game.version_title].
   */
  VERSION_TITLE("version_title"),
  /**
   *  Field "videos" of the [Game] IGDB entity. Matches [Game.videos].
   */
  VIDEOS("videos"),
  /**
   *  Field "websites" of the [Game] IGDB entity. Matches [Game.websites].
   */
  WEBSITES("websites"),
  /**
   *  Field "checksum" of the [Game] IGDB entity. Matches [Game.checksum].
   */
  CHECKSUM("checksum"),
  /**
   *  Field "remakes" of the [Game] IGDB entity. Matches [Game.remakes].
   */
  REMAKES("remakes"),
  /**
   *  Field "remasters" of the [Game] IGDB entity. Matches [Game.remasters].
   */
  REMASTERS("remasters"),
  /**
   *  Field "expanded_games" of the [Game] IGDB entity. Matches [Game.expanded_games].
   */
  EXPANDED_GAMES("expanded_games"),
  /**
   *  Field "ports" of the [Game] IGDB entity. Matches [Game.ports].
   */
  PORTS("ports"),
  /**
   *  Field "forks" of the [Game] IGDB entity. Matches [Game.forks].
   */
  FORKS("forks"),
  /**
   *  Field "language_supports" of the [Game] IGDB entity. Matches [Game.language_supports].
   */
  LANGUAGE_SUPPORTS("language_supports"),
  /**
   *  Field "game_localizations" of the [Game] IGDB entity. Matches [Game.game_localizations].
   */
  GAME_LOCALIZATIONS("game_localizations"),
  /**
   *  Field "collections" of the [Game] IGDB entity. Matches [Game.collections].
   */
  COLLECTIONS("collections"),
  ;

  override fun toString(): String = igdbName
}
