package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.GameMode

/**
 *  Fields of the [GameMode] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-mode](https://api-docs.igdb.com/#game-mode)
 */
public enum class GameModeField(
  public override val igdbName: String,
) : IgdbField<GameMode> {
  /**
   *  Field "id" of the [GameMode] IGDB entity. Matches [GameMode.id].
   */
  ID("id"),
  /**
   *  Field "created_at" of the [GameMode] IGDB entity. Matches [GameMode.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "name" of the [GameMode] IGDB entity. Matches [GameMode.name].
   */
  NAME("name"),
  /**
   *  Field "slug" of the [GameMode] IGDB entity. Matches [GameMode.slug].
   */
  SLUG("slug"),
  /**
   *  Field "updated_at" of the [GameMode] IGDB entity. Matches [GameMode.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [GameMode] IGDB entity. Matches [GameMode.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [GameMode] IGDB entity. Matches [GameMode.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
