package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.GameVideo

/**
 *  Fields of the [GameVideo] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-video](https://api-docs.igdb.com/#game-video)
 */
public enum class GameVideoField(
  public override val igdbName: String,
) : IgdbField<GameVideo> {
  /**
   *  Field "id" of the [GameVideo] IGDB entity. Matches [GameVideo.id].
   */
  ID("id"),
  /**
   *  Field "game" of the [GameVideo] IGDB entity. Matches [GameVideo.game].
   */
  GAME("game"),
  /**
   *  Field "name" of the [GameVideo] IGDB entity. Matches [GameVideo.name].
   */
  NAME("name"),
  /**
   *  Field "video_id" of the [GameVideo] IGDB entity. Matches [GameVideo.video_id].
   */
  VIDEO_ID("video_id"),
  /**
   *  Field "checksum" of the [GameVideo] IGDB entity. Matches [GameVideo.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
