package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.InvolvedCompany

/**
 *  Fields of the [InvolvedCompany] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#involved-company](https://api-docs.igdb.com/#involved-company)
 */
public enum class InvolvedCompanyField(
  public override val igdbName: String,
) : IgdbField<InvolvedCompany> {
  /**
   *  Field "id" of the [InvolvedCompany] IGDB entity. Matches [InvolvedCompany.id].
   */
  ID("id"),
  /**
   *  Field "company" of the [InvolvedCompany] IGDB entity. Matches [InvolvedCompany.company].
   */
  COMPANY("company"),
  /**
   *  Field "created_at" of the [InvolvedCompany] IGDB entity. Matches [InvolvedCompany.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "developer" of the [InvolvedCompany] IGDB entity. Matches [InvolvedCompany.developer].
   */
  DEVELOPER("developer"),
  /**
   *  Field "game" of the [InvolvedCompany] IGDB entity. Matches [InvolvedCompany.game].
   */
  GAME("game"),
  /**
   *  Field "porting" of the [InvolvedCompany] IGDB entity. Matches [InvolvedCompany.porting].
   */
  PORTING("porting"),
  /**
   *  Field "publisher" of the [InvolvedCompany] IGDB entity. Matches [InvolvedCompany.publisher].
   */
  PUBLISHER("publisher"),
  /**
   *  Field "supporting" of the [InvolvedCompany] IGDB entity. Matches [InvolvedCompany.supporting].
   */
  SUPPORTING("supporting"),
  /**
   *  Field "updated_at" of the [InvolvedCompany] IGDB entity. Matches [InvolvedCompany.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [InvolvedCompany] IGDB entity. Matches [InvolvedCompany.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
