package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.NetworkType

/**
 *  Fields of the [NetworkType] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#network-type](https://api-docs.igdb.com/#network-type)
 */
public enum class NetworkTypeField(
  public override val igdbName: String,
) : IgdbField<NetworkType> {
  /**
   *  Field "id" of the [NetworkType] IGDB entity. Matches [NetworkType.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [NetworkType] IGDB entity. Matches [NetworkType.name].
   */
  NAME("name"),
  /**
   *  Field "event_networks" of the [NetworkType] IGDB entity. Matches [NetworkType.event_networks].
   */
  EVENT_NETWORKS("event_networks"),
  /**
   *  Field "created_at" of the [NetworkType] IGDB entity. Matches [NetworkType.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [NetworkType] IGDB entity. Matches [NetworkType.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [NetworkType] IGDB entity. Matches [NetworkType.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
