package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.CollectionRelationType
import ru.pixnews.igdbclient.scheme.`field`.CollectionRelationTypeField

private val _collectionRelationTypeFieldDslInstance: CollectionRelationTypeFieldDsl =
    CollectionRelationTypeFieldDsl()

public val CollectionRelationType.Companion.`field`: CollectionRelationTypeFieldDsl
  get() = _collectionRelationTypeFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [CollectionRelationType] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#collection-relation-type](https://api-docs.igdb.com/#collection-relation-type)
 */
@IgdbClientDsl
public class CollectionRelationTypeFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CollectionRelationTypeField, CollectionRelationType>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [CollectionRelationType] Igdb entity.
   *
   *  The value will be returned in the [CollectionRelationType.id] field of the response
   */
  public val id: IgdbRequestField<CollectionRelationType>
    get() = fieldWithId(CollectionRelationTypeField.ID)

  /**
   *  Query for the "name" field of the [CollectionRelationType] Igdb entity.
   *
   *  The value will be returned in the [CollectionRelationType.name] field of the response
   */
  public val name: IgdbRequestField<CollectionRelationType>
    get() = fieldWithId(CollectionRelationTypeField.NAME)

  /**
   *  Query for the "description" field of the [CollectionRelationType] Igdb entity.
   *
   *  The value will be returned in the [CollectionRelationType.description] field of the response
   */
  public val description: IgdbRequestField<CollectionRelationType>
    get() = fieldWithId(CollectionRelationTypeField.DESCRIPTION)

  /**
   *  Fields of the "allowed_child_type"
   * ([CollectionType][ru.pixnews.igdbclient.model.CollectionType]) nested IGDB entity
   */
  public val allowed_child_type: CollectionTypeFieldDsl
    get() = CollectionTypeFieldDsl(fieldWithId(CollectionRelationTypeField.ALLOWED_CHILD_TYPE))

  /**
   *  Fields of the "allowed_parent_type"
   * ([CollectionType][ru.pixnews.igdbclient.model.CollectionType]) nested IGDB entity
   */
  public val allowed_parent_type: CollectionTypeFieldDsl
    get() = CollectionTypeFieldDsl(fieldWithId(CollectionRelationTypeField.ALLOWED_PARENT_TYPE))

  /**
   *  Query for the "updated_at" field of the [CollectionRelationType] Igdb entity.
   *
   *  The value will be returned in the [CollectionRelationType.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<CollectionRelationType>
    get() = fieldWithId(CollectionRelationTypeField.UPDATED_AT)

  /**
   *  Query for the "created_at" field of the [CollectionRelationType] Igdb entity.
   *
   *  The value will be returned in the [CollectionRelationType.created_at] field of the response
   */
  public val created_at: IgdbRequestField<CollectionRelationType>
    get() = fieldWithId(CollectionRelationTypeField.CREATED_AT)

  /**
   *  Query for the "checksum" field of the [CollectionRelationType] Igdb entity.
   *
   *  The value will be returned in the [CollectionRelationType.checksum] field of the response
   */
  public val checksum: IgdbRequestField<CollectionRelationType>
    get() = fieldWithId(CollectionRelationTypeField.CHECKSUM)
}
