package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.PopularityPrimitive
import ru.pixnews.igdbclient.scheme.`field`.PopularityPrimitiveField

private val _popularityPrimitiveFieldDslInstance: PopularityPrimitiveFieldDsl =
    PopularityPrimitiveFieldDsl()

public val PopularityPrimitive.Companion.`field`: PopularityPrimitiveFieldDsl
  get() = _popularityPrimitiveFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [PopularityPrimitive] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#popularity-primitive](https://api-docs.igdb.com/#popularity-primitive)
 */
@IgdbClientDsl
public class PopularityPrimitiveFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<PopularityPrimitiveField, PopularityPrimitive>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [PopularityPrimitive] Igdb entity.
   *
   *  The value will be returned in the [PopularityPrimitive.id] field of the response
   */
  public val id: IgdbRequestField<PopularityPrimitive>
    get() = fieldWithId(PopularityPrimitiveField.ID)

  /**
   *  Query for the "game_id" field of the [PopularityPrimitive] Igdb entity.
   *
   *  The value will be returned in the [PopularityPrimitive.game_id] field of the response
   */
  public val game_id: IgdbRequestField<PopularityPrimitive>
    get() = fieldWithId(PopularityPrimitiveField.GAME_ID)

  /**
   *  Fields of the "popularity_type" ([PopularityType][ru.pixnews.igdbclient.model.PopularityType])
   * nested IGDB entity
   */
  public val popularity_type: PopularityTypeFieldDsl
    get() = PopularityTypeFieldDsl(fieldWithId(PopularityPrimitiveField.POPULARITY_TYPE))

  /**
   *  Query for the "popularity_source" field of the [PopularityPrimitive] Igdb entity.
   *
   *  The value will be returned in the [PopularityPrimitive.popularity_source] field of the
   * response
   */
  public val popularity_source: IgdbRequestField<PopularityPrimitive>
    get() = fieldWithId(PopularityPrimitiveField.POPULARITY_SOURCE)

  /**
   *  Query for the "value" field of the [PopularityPrimitive] Igdb entity.
   *
   *  The value will be returned in the [PopularityPrimitive.`value`] field of the response
   */
  public val `value`: IgdbRequestField<PopularityPrimitive>
    get() = fieldWithId(PopularityPrimitiveField.VALUE)

  /**
   *  Query for the "calculated_at" field of the [PopularityPrimitive] Igdb entity.
   *
   *  The value will be returned in the [PopularityPrimitive.calculated_at] field of the response
   */
  public val calculated_at: IgdbRequestField<PopularityPrimitive>
    get() = fieldWithId(PopularityPrimitiveField.CALCULATED_AT)

  /**
   *  Query for the "created_at" field of the [PopularityPrimitive] Igdb entity.
   *
   *  The value will be returned in the [PopularityPrimitive.created_at] field of the response
   */
  public val created_at: IgdbRequestField<PopularityPrimitive>
    get() = fieldWithId(PopularityPrimitiveField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [PopularityPrimitive] Igdb entity.
   *
   *  The value will be returned in the [PopularityPrimitive.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<PopularityPrimitive>
    get() = fieldWithId(PopularityPrimitiveField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [PopularityPrimitive] Igdb entity.
   *
   *  The value will be returned in the [PopularityPrimitive.checksum] field of the response
   */
  public val checksum: IgdbRequestField<PopularityPrimitive>
    get() = fieldWithId(PopularityPrimitiveField.CHECKSUM)
}
