package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Platform

/**
 *  Fields of the [Platform] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#platform](https://api-docs.igdb.com/#platform)
 */
public enum class PlatformField(
  public override val igdbName: String,
) : IgdbField<Platform> {
  /**
   *  Field "id" of the [Platform] IGDB entity. Matches [Platform.id].
   */
  ID("id"),
  /**
   *  Field "abbreviation" of the [Platform] IGDB entity. Matches [Platform.abbreviation].
   */
  ABBREVIATION("abbreviation"),
  /**
   *  Field "alternative_name" of the [Platform] IGDB entity. Matches [Platform.alternative_name].
   */
  ALTERNATIVE_NAME("alternative_name"),
  /**
   *  Field "category" of the [Platform] IGDB entity. Matches [Platform.category].
   */
  CATEGORY("category"),
  /**
   *  Field "created_at" of the [Platform] IGDB entity. Matches [Platform.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "generation" of the [Platform] IGDB entity. Matches [Platform.generation].
   */
  GENERATION("generation"),
  /**
   *  Field "name" of the [Platform] IGDB entity. Matches [Platform.name].
   */
  NAME("name"),
  /**
   *  Field "platform_logo" of the [Platform] IGDB entity. Matches [Platform.platform_logo].
   */
  PLATFORM_LOGO("platform_logo"),
  /**
   *  Field "platform_family" of the [Platform] IGDB entity. Matches [Platform.platform_family].
   */
  PLATFORM_FAMILY("platform_family"),
  /**
   *  Field "slug" of the [Platform] IGDB entity. Matches [Platform.slug].
   */
  SLUG("slug"),
  /**
   *  Field "summary" of the [Platform] IGDB entity. Matches [Platform.summary].
   */
  SUMMARY("summary"),
  /**
   *  Field "updated_at" of the [Platform] IGDB entity. Matches [Platform.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [Platform] IGDB entity. Matches [Platform.url].
   */
  URL("url"),
  /**
   *  Field "versions" of the [Platform] IGDB entity. Matches [Platform.versions].
   */
  VERSIONS("versions"),
  /**
   *  Field "websites" of the [Platform] IGDB entity. Matches [Platform.websites].
   */
  WEBSITES("websites"),
  /**
   *  Field "checksum" of the [Platform] IGDB entity. Matches [Platform.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
