package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.PopularityType

/**
 *  Fields of the [PopularityType] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#popularity-type](https://api-docs.igdb.com/#popularity-type)
 */
public enum class PopularityTypeField(
  public override val igdbName: String,
) : IgdbField<PopularityType> {
  /**
   *  Field "id" of the [PopularityType] IGDB entity. Matches [PopularityType.id].
   */
  ID("id"),
  /**
   *  Field "popularity_source" of the [PopularityType] IGDB entity. Matches
   * [PopularityType.popularity_source].
   */
  POPULARITY_SOURCE("popularity_source"),
  /**
   *  Field "name" of the [PopularityType] IGDB entity. Matches [PopularityType.name].
   */
  NAME("name"),
  /**
   *  Field "created_at" of the [PopularityType] IGDB entity. Matches [PopularityType.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [PopularityType] IGDB entity. Matches [PopularityType.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [PopularityType] IGDB entity. Matches [PopularityType.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
