package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.GameEngine
import ru.pixnews.igdbclient.scheme.`field`.GameEngineField

private val _gameEngineFieldDslInstance: GameEngineFieldDsl = GameEngineFieldDsl()

public val GameEngine.Companion.`field`: GameEngineFieldDsl
  get() = _gameEngineFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [GameEngine] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-engine](https://api-docs.igdb.com/#game-engine)
 */
@IgdbClientDsl
public class GameEngineFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<GameEngineField, GameEngine>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [GameEngine] Igdb entity.
   *
   *  The value will be returned in the [GameEngine.id] field of the response
   */
  public val id: IgdbRequestField<GameEngine>
    get() = fieldWithId(GameEngineField.ID)

  /**
   *  Fields of the "companies" ([Company][ru.pixnews.igdbclient.model.Company]) nested IGDB entity
   */
  public val companies: CompanyFieldDsl
    get() = CompanyFieldDsl(fieldWithId(GameEngineField.COMPANIES))

  /**
   *  Query for the "created_at" field of the [GameEngine] Igdb entity.
   *
   *  The value will be returned in the [GameEngine.created_at] field of the response
   */
  public val created_at: IgdbRequestField<GameEngine>
    get() = fieldWithId(GameEngineField.CREATED_AT)

  /**
   *  Query for the "description" field of the [GameEngine] Igdb entity.
   *
   *  The value will be returned in the [GameEngine.description] field of the response
   */
  public val description: IgdbRequestField<GameEngine>
    get() = fieldWithId(GameEngineField.DESCRIPTION)

  /**
   *  Fields of the "logo" ([GameEngineLogo][ru.pixnews.igdbclient.model.GameEngineLogo]) nested
   * IGDB entity
   */
  public val logo: GameEngineLogoFieldDsl
    get() = GameEngineLogoFieldDsl(fieldWithId(GameEngineField.LOGO))

  /**
   *  Query for the "name" field of the [GameEngine] Igdb entity.
   *
   *  The value will be returned in the [GameEngine.name] field of the response
   */
  public val name: IgdbRequestField<GameEngine>
    get() = fieldWithId(GameEngineField.NAME)

  /**
   *  Fields of the "platforms" ([Platform][ru.pixnews.igdbclient.model.Platform]) nested IGDB
   * entity
   */
  public val platforms: PlatformFieldDsl
    get() = PlatformFieldDsl(fieldWithId(GameEngineField.PLATFORMS))

  /**
   *  Query for the "slug" field of the [GameEngine] Igdb entity.
   *
   *  The value will be returned in the [GameEngine.slug] field of the response
   */
  public val slug: IgdbRequestField<GameEngine>
    get() = fieldWithId(GameEngineField.SLUG)

  /**
   *  Query for the "updated_at" field of the [GameEngine] Igdb entity.
   *
   *  The value will be returned in the [GameEngine.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<GameEngine>
    get() = fieldWithId(GameEngineField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [GameEngine] Igdb entity.
   *
   *  The value will be returned in the [GameEngine.url] field of the response
   */
  public val url: IgdbRequestField<GameEngine>
    get() = fieldWithId(GameEngineField.URL)

  /**
   *  Query for the "checksum" field of the [GameEngine] Igdb entity.
   *
   *  The value will be returned in the [GameEngine.checksum] field of the response
   */
  public val checksum: IgdbRequestField<GameEngine>
    get() = fieldWithId(GameEngineField.CHECKSUM)
}
