package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.LanguageSupport
import ru.pixnews.igdbclient.scheme.`field`.LanguageSupportField

private val _languageSupportFieldDslInstance: LanguageSupportFieldDsl = LanguageSupportFieldDsl()

public val LanguageSupport.Companion.`field`: LanguageSupportFieldDsl
  get() = _languageSupportFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [LanguageSupport] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#language-support](https://api-docs.igdb.com/#language-support)
 */
@IgdbClientDsl
public class LanguageSupportFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<LanguageSupportField, LanguageSupport>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [LanguageSupport] Igdb entity.
   *
   *  The value will be returned in the [LanguageSupport.id] field of the response
   */
  public val id: IgdbRequestField<LanguageSupport>
    get() = fieldWithId(LanguageSupportField.ID)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(LanguageSupportField.GAME))

  /**
   *  Fields of the "language" ([Language][ru.pixnews.igdbclient.model.Language]) nested IGDB entity
   */
  public val language: LanguageFieldDsl
    get() = LanguageFieldDsl(fieldWithId(LanguageSupportField.LANGUAGE))

  /**
   *  Fields of the "language_support_type"
   * ([LanguageSupportType][ru.pixnews.igdbclient.model.LanguageSupportType]) nested IGDB entity
   */
  public val language_support_type: LanguageSupportTypeFieldDsl
    get() = LanguageSupportTypeFieldDsl(fieldWithId(LanguageSupportField.LANGUAGE_SUPPORT_TYPE))

  /**
   *  Query for the "created_at" field of the [LanguageSupport] Igdb entity.
   *
   *  The value will be returned in the [LanguageSupport.created_at] field of the response
   */
  public val created_at: IgdbRequestField<LanguageSupport>
    get() = fieldWithId(LanguageSupportField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [LanguageSupport] Igdb entity.
   *
   *  The value will be returned in the [LanguageSupport.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<LanguageSupport>
    get() = fieldWithId(LanguageSupportField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [LanguageSupport] Igdb entity.
   *
   *  The value will be returned in the [LanguageSupport.checksum] field of the response
   */
  public val checksum: IgdbRequestField<LanguageSupport>
    get() = fieldWithId(LanguageSupportField.CHECKSUM)
}
