package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.PlatformWebsite
import ru.pixnews.igdbclient.scheme.`field`.PlatformWebsiteField

private val _platformWebsiteFieldDslInstance: PlatformWebsiteFieldDsl = PlatformWebsiteFieldDsl()

public val PlatformWebsite.Companion.`field`: PlatformWebsiteFieldDsl
  get() = _platformWebsiteFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [PlatformWebsite] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#platform-website](https://api-docs.igdb.com/#platform-website)
 */
@IgdbClientDsl
public class PlatformWebsiteFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<PlatformWebsiteField, PlatformWebsite>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [PlatformWebsite] Igdb entity.
   *
   *  The value will be returned in the [PlatformWebsite.id] field of the response
   */
  public val id: IgdbRequestField<PlatformWebsite>
    get() = fieldWithId(PlatformWebsiteField.ID)

  /**
   *  Query for the "category" field of the [PlatformWebsite] Igdb entity.
   *
   *  The value will be returned in the [PlatformWebsite.category] field of the response
   */
  public val category: IgdbRequestField<PlatformWebsite>
    get() = fieldWithId(PlatformWebsiteField.CATEGORY)

  /**
   *  Query for the "trusted" field of the [PlatformWebsite] Igdb entity.
   *
   *  The value will be returned in the [PlatformWebsite.trusted] field of the response
   */
  public val trusted: IgdbRequestField<PlatformWebsite>
    get() = fieldWithId(PlatformWebsiteField.TRUSTED)

  /**
   *  Query for the "url" field of the [PlatformWebsite] Igdb entity.
   *
   *  The value will be returned in the [PlatformWebsite.url] field of the response
   */
  public val url: IgdbRequestField<PlatformWebsite>
    get() = fieldWithId(PlatformWebsiteField.URL)

  /**
   *  Query for the "checksum" field of the [PlatformWebsite] Igdb entity.
   *
   *  The value will be returned in the [PlatformWebsite.checksum] field of the response
   */
  public val checksum: IgdbRequestField<PlatformWebsite>
    get() = fieldWithId(PlatformWebsiteField.CHECKSUM)
}
