package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.AlternativeName

/**
 *  Fields of the [AlternativeName] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#alternative-name](https://api-docs.igdb.com/#alternative-name)
 */
public enum class AlternativeNameField(
  public override val igdbName: String,
) : IgdbField<AlternativeName> {
  /**
   *  Field "id" of the [AlternativeName] IGDB entity. Matches [AlternativeName.id].
   */
  ID("id"),
  /**
   *  Field "comment" of the [AlternativeName] IGDB entity. Matches [AlternativeName.comment].
   */
  COMMENT("comment"),
  /**
   *  Field "game" of the [AlternativeName] IGDB entity. Matches [AlternativeName.game].
   */
  GAME("game"),
  /**
   *  Field "name" of the [AlternativeName] IGDB entity. Matches [AlternativeName.name].
   */
  NAME("name"),
  /**
   *  Field "checksum" of the [AlternativeName] IGDB entity. Matches [AlternativeName.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
