package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Artwork

/**
 *  Fields of the [Artwork] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#artwork](https://api-docs.igdb.com/#artwork)
 */
public enum class ArtworkField(
  public override val igdbName: String,
) : IgdbField<Artwork> {
  /**
   *  Field "id" of the [Artwork] IGDB entity. Matches [Artwork.id].
   */
  ID("id"),
  /**
   *  Field "alpha_channel" of the [Artwork] IGDB entity. Matches [Artwork.alpha_channel].
   */
  ALPHA_CHANNEL("alpha_channel"),
  /**
   *  Field "animated" of the [Artwork] IGDB entity. Matches [Artwork.animated].
   */
  ANIMATED("animated"),
  /**
   *  Field "game" of the [Artwork] IGDB entity. Matches [Artwork.game].
   */
  GAME("game"),
  /**
   *  Field "height" of the [Artwork] IGDB entity. Matches [Artwork.height].
   */
  HEIGHT("height"),
  /**
   *  Field "image_id" of the [Artwork] IGDB entity. Matches [Artwork.image_id].
   */
  IMAGE_ID("image_id"),
  /**
   *  Field "url" of the [Artwork] IGDB entity. Matches [Artwork.url].
   */
  URL("url"),
  /**
   *  Field "width" of the [Artwork] IGDB entity. Matches [Artwork.width].
   */
  WIDTH("width"),
  /**
   *  Field "checksum" of the [Artwork] IGDB entity. Matches [Artwork.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
