package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.CharacterMugShot

/**
 *  Fields of the [CharacterMugShot] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#character-mug-shot](https://api-docs.igdb.com/#character-mug-shot)
 */
public enum class CharacterMugShotField(
  public override val igdbName: String,
) : IgdbField<CharacterMugShot> {
  /**
   *  Field "id" of the [CharacterMugShot] IGDB entity. Matches [CharacterMugShot.id].
   */
  ID("id"),
  /**
   *  Field "alpha_channel" of the [CharacterMugShot] IGDB entity. Matches
   * [CharacterMugShot.alpha_channel].
   */
  ALPHA_CHANNEL("alpha_channel"),
  /**
   *  Field "animated" of the [CharacterMugShot] IGDB entity. Matches [CharacterMugShot.animated].
   */
  ANIMATED("animated"),
  /**
   *  Field "height" of the [CharacterMugShot] IGDB entity. Matches [CharacterMugShot.height].
   */
  HEIGHT("height"),
  /**
   *  Field "image_id" of the [CharacterMugShot] IGDB entity. Matches [CharacterMugShot.image_id].
   */
  IMAGE_ID("image_id"),
  /**
   *  Field "url" of the [CharacterMugShot] IGDB entity. Matches [CharacterMugShot.url].
   */
  URL("url"),
  /**
   *  Field "width" of the [CharacterMugShot] IGDB entity. Matches [CharacterMugShot.width].
   */
  WIDTH("width"),
  /**
   *  Field "checksum" of the [CharacterMugShot] IGDB entity. Matches [CharacterMugShot.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
