package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.GameVersion
import ru.pixnews.igdbclient.scheme.`field`.GameVersionField

private val _gameVersionFieldDslInstance: GameVersionFieldDsl = GameVersionFieldDsl()

public val GameVersion.Companion.`field`: GameVersionFieldDsl
  get() = _gameVersionFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [GameVersion] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-version](https://api-docs.igdb.com/#game-version)
 */
@IgdbClientDsl
public class GameVersionFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<GameVersionField, GameVersion>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [GameVersion] Igdb entity.
   *
   *  The value will be returned in the [GameVersion.id] field of the response
   */
  public val id: IgdbRequestField<GameVersion>
    get() = fieldWithId(GameVersionField.ID)

  /**
   *  Query for the "created_at" field of the [GameVersion] Igdb entity.
   *
   *  The value will be returned in the [GameVersion.created_at] field of the response
   */
  public val created_at: IgdbRequestField<GameVersion>
    get() = fieldWithId(GameVersionField.CREATED_AT)

  /**
   *  Fields of the "features"
   * ([GameVersionFeature][ru.pixnews.igdbclient.model.GameVersionFeature]) nested IGDB entity
   */
  public val features: GameVersionFeatureFieldDsl
    get() = GameVersionFeatureFieldDsl(fieldWithId(GameVersionField.FEATURES))

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameVersionField.GAME))

  /**
   *  Fields of the "games" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val games: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameVersionField.GAMES))

  /**
   *  Query for the "updated_at" field of the [GameVersion] Igdb entity.
   *
   *  The value will be returned in the [GameVersion.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<GameVersion>
    get() = fieldWithId(GameVersionField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [GameVersion] Igdb entity.
   *
   *  The value will be returned in the [GameVersion.url] field of the response
   */
  public val url: IgdbRequestField<GameVersion>
    get() = fieldWithId(GameVersionField.URL)

  /**
   *  Query for the "checksum" field of the [GameVersion] Igdb entity.
   *
   *  The value will be returned in the [GameVersion.checksum] field of the response
   */
  public val checksum: IgdbRequestField<GameVersion>
    get() = fieldWithId(GameVersionField.CHECKSUM)
}
