package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.PlatformLogo
import ru.pixnews.igdbclient.scheme.`field`.PlatformLogoField

private val _platformLogoFieldDslInstance: PlatformLogoFieldDsl = PlatformLogoFieldDsl()

public val PlatformLogo.Companion.`field`: PlatformLogoFieldDsl
  get() = _platformLogoFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [PlatformLogo] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#platform-logo](https://api-docs.igdb.com/#platform-logo)
 */
@IgdbClientDsl
public class PlatformLogoFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<PlatformLogoField, PlatformLogo>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [PlatformLogo] Igdb entity.
   *
   *  The value will be returned in the [PlatformLogo.id] field of the response
   */
  public val id: IgdbRequestField<PlatformLogo>
    get() = fieldWithId(PlatformLogoField.ID)

  /**
   *  Query for the "alpha_channel" field of the [PlatformLogo] Igdb entity.
   *
   *  The value will be returned in the [PlatformLogo.alpha_channel] field of the response
   */
  public val alpha_channel: IgdbRequestField<PlatformLogo>
    get() = fieldWithId(PlatformLogoField.ALPHA_CHANNEL)

  /**
   *  Query for the "animated" field of the [PlatformLogo] Igdb entity.
   *
   *  The value will be returned in the [PlatformLogo.animated] field of the response
   */
  public val animated: IgdbRequestField<PlatformLogo>
    get() = fieldWithId(PlatformLogoField.ANIMATED)

  /**
   *  Query for the "height" field of the [PlatformLogo] Igdb entity.
   *
   *  The value will be returned in the [PlatformLogo.height] field of the response
   */
  public val height: IgdbRequestField<PlatformLogo>
    get() = fieldWithId(PlatformLogoField.HEIGHT)

  /**
   *  Query for the "image_id" field of the [PlatformLogo] Igdb entity.
   *
   *  The value will be returned in the [PlatformLogo.image_id] field of the response
   */
  public val image_id: IgdbRequestField<PlatformLogo>
    get() = fieldWithId(PlatformLogoField.IMAGE_ID)

  /**
   *  Query for the "url" field of the [PlatformLogo] Igdb entity.
   *
   *  The value will be returned in the [PlatformLogo.url] field of the response
   */
  public val url: IgdbRequestField<PlatformLogo>
    get() = fieldWithId(PlatformLogoField.URL)

  /**
   *  Query for the "width" field of the [PlatformLogo] Igdb entity.
   *
   *  The value will be returned in the [PlatformLogo.width] field of the response
   */
  public val width: IgdbRequestField<PlatformLogo>
    get() = fieldWithId(PlatformLogoField.WIDTH)

  /**
   *  Query for the "checksum" field of the [PlatformLogo] Igdb entity.
   *
   *  The value will be returned in the [PlatformLogo.checksum] field of the response
   */
  public val checksum: IgdbRequestField<PlatformLogo>
    get() = fieldWithId(PlatformLogoField.CHECKSUM)
}
