package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Theme
import ru.pixnews.igdbclient.scheme.`field`.ThemeField

private val _themeFieldDslInstance: ThemeFieldDsl = ThemeFieldDsl()

public val Theme.Companion.`field`: ThemeFieldDsl
  get() = _themeFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Theme] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#theme](https://api-docs.igdb.com/#theme)
 */
@IgdbClientDsl
public class ThemeFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<ThemeField, Theme>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Theme] Igdb entity.
   *
   *  The value will be returned in the [Theme.id] field of the response
   */
  public val id: IgdbRequestField<Theme>
    get() = fieldWithId(ThemeField.ID)

  /**
   *  Query for the "created_at" field of the [Theme] Igdb entity.
   *
   *  The value will be returned in the [Theme.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Theme>
    get() = fieldWithId(ThemeField.CREATED_AT)

  /**
   *  Query for the "name" field of the [Theme] Igdb entity.
   *
   *  The value will be returned in the [Theme.name] field of the response
   */
  public val name: IgdbRequestField<Theme>
    get() = fieldWithId(ThemeField.NAME)

  /**
   *  Query for the "slug" field of the [Theme] Igdb entity.
   *
   *  The value will be returned in the [Theme.slug] field of the response
   */
  public val slug: IgdbRequestField<Theme>
    get() = fieldWithId(ThemeField.SLUG)

  /**
   *  Query for the "updated_at" field of the [Theme] Igdb entity.
   *
   *  The value will be returned in the [Theme.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Theme>
    get() = fieldWithId(ThemeField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [Theme] Igdb entity.
   *
   *  The value will be returned in the [Theme.url] field of the response
   */
  public val url: IgdbRequestField<Theme>
    get() = fieldWithId(ThemeField.URL)

  /**
   *  Query for the "checksum" field of the [Theme] Igdb entity.
   *
   *  The value will be returned in the [Theme.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Theme>
    get() = fieldWithId(ThemeField.CHECKSUM)
}
