package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.AgeRating

/**
 *  Fields of the [AgeRating] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#age-rating](https://api-docs.igdb.com/#age-rating)
 */
public enum class AgeRatingField(
  public override val igdbName: String,
) : IgdbField<AgeRating> {
  /**
   *  Field "id" of the [AgeRating] IGDB entity. Matches [AgeRating.id].
   */
  ID("id"),
  /**
   *  Field "category" of the [AgeRating] IGDB entity. Matches [AgeRating.category].
   */
  CATEGORY("category"),
  /**
   *  Field "content_descriptions" of the [AgeRating] IGDB entity. Matches
   * [AgeRating.content_descriptions].
   */
  CONTENT_DESCRIPTIONS("content_descriptions"),
  /**
   *  Field "rating" of the [AgeRating] IGDB entity. Matches [AgeRating.rating].
   */
  RATING("rating"),
  /**
   *  Field "rating_cover_url" of the [AgeRating] IGDB entity. Matches [AgeRating.rating_cover_url].
   */
  RATING_COVER_URL("rating_cover_url"),
  /**
   *  Field "synopsis" of the [AgeRating] IGDB entity. Matches [AgeRating.synopsis].
   */
  SYNOPSIS("synopsis"),
  /**
   *  Field "checksum" of the [AgeRating] IGDB entity. Matches [AgeRating.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
