package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.LanguageSupport

/**
 *  Fields of the [LanguageSupport] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#language-support](https://api-docs.igdb.com/#language-support)
 */
public enum class LanguageSupportField(
  public override val igdbName: String,
) : IgdbField<LanguageSupport> {
  /**
   *  Field "id" of the [LanguageSupport] IGDB entity. Matches [LanguageSupport.id].
   */
  ID("id"),
  /**
   *  Field "game" of the [LanguageSupport] IGDB entity. Matches [LanguageSupport.game].
   */
  GAME("game"),
  /**
   *  Field "language" of the [LanguageSupport] IGDB entity. Matches [LanguageSupport.language].
   */
  LANGUAGE("language"),
  /**
   *  Field "language_support_type" of the [LanguageSupport] IGDB entity. Matches
   * [LanguageSupport.language_support_type].
   */
  LANGUAGE_SUPPORT_TYPE("language_support_type"),
  /**
   *  Field "created_at" of the [LanguageSupport] IGDB entity. Matches [LanguageSupport.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [LanguageSupport] IGDB entity. Matches [LanguageSupport.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [LanguageSupport] IGDB entity. Matches [LanguageSupport.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
