package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.PlatformLogo

/**
 *  Fields of the [PlatformLogo] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#platform-logo](https://api-docs.igdb.com/#platform-logo)
 */
public enum class PlatformLogoField(
  public override val igdbName: String,
) : IgdbField<PlatformLogo> {
  /**
   *  Field "id" of the [PlatformLogo] IGDB entity. Matches [PlatformLogo.id].
   */
  ID("id"),
  /**
   *  Field "alpha_channel" of the [PlatformLogo] IGDB entity. Matches [PlatformLogo.alpha_channel].
   */
  ALPHA_CHANNEL("alpha_channel"),
  /**
   *  Field "animated" of the [PlatformLogo] IGDB entity. Matches [PlatformLogo.animated].
   */
  ANIMATED("animated"),
  /**
   *  Field "height" of the [PlatformLogo] IGDB entity. Matches [PlatformLogo.height].
   */
  HEIGHT("height"),
  /**
   *  Field "image_id" of the [PlatformLogo] IGDB entity. Matches [PlatformLogo.image_id].
   */
  IMAGE_ID("image_id"),
  /**
   *  Field "url" of the [PlatformLogo] IGDB entity. Matches [PlatformLogo.url].
   */
  URL("url"),
  /**
   *  Field "width" of the [PlatformLogo] IGDB entity. Matches [PlatformLogo.width].
   */
  WIDTH("width"),
  /**
   *  Field "checksum" of the [PlatformLogo] IGDB entity. Matches [PlatformLogo.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
