package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.EventNetwork

/**
 *  Fields of the [EventNetwork] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#event-network](https://api-docs.igdb.com/#event-network)
 */
public enum class EventNetworkField(
  public override val igdbName: String,
) : IgdbField<EventNetwork> {
  /**
   *  Field "id" of the [EventNetwork] IGDB entity. Matches [EventNetwork.id].
   */
  ID("id"),
  /**
   *  Field "event" of the [EventNetwork] IGDB entity. Matches [EventNetwork.event].
   */
  EVENT("event"),
  /**
   *  Field "url" of the [EventNetwork] IGDB entity. Matches [EventNetwork.url].
   */
  URL("url"),
  /**
   *  Field "network_type" of the [EventNetwork] IGDB entity. Matches [EventNetwork.network_type].
   */
  NETWORK_TYPE("network_type"),
  /**
   *  Field "created_at" of the [EventNetwork] IGDB entity. Matches [EventNetwork.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [EventNetwork] IGDB entity. Matches [EventNetwork.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [EventNetwork] IGDB entity. Matches [EventNetwork.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
