package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Artwork
import ru.pixnews.igdbclient.scheme.`field`.ArtworkField

private val _artworkFieldDslInstance: ArtworkFieldDsl = ArtworkFieldDsl()

public val Artwork.Companion.`field`: ArtworkFieldDsl
  get() = _artworkFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Artwork] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#artwork](https://api-docs.igdb.com/#artwork)
 */
@IgdbClientDsl
public class ArtworkFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<ArtworkField, Artwork>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Artwork] Igdb entity.
   *
   *  The value will be returned in the [Artwork.id] field of the response
   */
  public val id: IgdbRequestField<Artwork>
    get() = fieldWithId(ArtworkField.ID)

  /**
   *  Query for the "alpha_channel" field of the [Artwork] Igdb entity.
   *
   *  The value will be returned in the [Artwork.alpha_channel] field of the response
   */
  public val alpha_channel: IgdbRequestField<Artwork>
    get() = fieldWithId(ArtworkField.ALPHA_CHANNEL)

  /**
   *  Query for the "animated" field of the [Artwork] Igdb entity.
   *
   *  The value will be returned in the [Artwork.animated] field of the response
   */
  public val animated: IgdbRequestField<Artwork>
    get() = fieldWithId(ArtworkField.ANIMATED)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(ArtworkField.GAME))

  /**
   *  Query for the "height" field of the [Artwork] Igdb entity.
   *
   *  The value will be returned in the [Artwork.height] field of the response
   */
  public val height: IgdbRequestField<Artwork>
    get() = fieldWithId(ArtworkField.HEIGHT)

  /**
   *  Query for the "image_id" field of the [Artwork] Igdb entity.
   *
   *  The value will be returned in the [Artwork.image_id] field of the response
   */
  public val image_id: IgdbRequestField<Artwork>
    get() = fieldWithId(ArtworkField.IMAGE_ID)

  /**
   *  Query for the "url" field of the [Artwork] Igdb entity.
   *
   *  The value will be returned in the [Artwork.url] field of the response
   */
  public val url: IgdbRequestField<Artwork>
    get() = fieldWithId(ArtworkField.URL)

  /**
   *  Query for the "width" field of the [Artwork] Igdb entity.
   *
   *  The value will be returned in the [Artwork.width] field of the response
   */
  public val width: IgdbRequestField<Artwork>
    get() = fieldWithId(ArtworkField.WIDTH)

  /**
   *  Query for the "checksum" field of the [Artwork] Igdb entity.
   *
   *  The value will be returned in the [Artwork.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Artwork>
    get() = fieldWithId(ArtworkField.CHECKSUM)
}
