package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.EventNetwork
import ru.pixnews.igdbclient.scheme.`field`.EventNetworkField

private val _eventNetworkFieldDslInstance: EventNetworkFieldDsl = EventNetworkFieldDsl()

public val EventNetwork.Companion.`field`: EventNetworkFieldDsl
  get() = _eventNetworkFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [EventNetwork] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#event-network](https://api-docs.igdb.com/#event-network)
 */
@IgdbClientDsl
public class EventNetworkFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<EventNetworkField, EventNetwork>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [EventNetwork] Igdb entity.
   *
   *  The value will be returned in the [EventNetwork.id] field of the response
   */
  public val id: IgdbRequestField<EventNetwork>
    get() = fieldWithId(EventNetworkField.ID)

  /**
   *  Fields of the "event" ([Event][ru.pixnews.igdbclient.model.Event]) nested IGDB entity
   */
  public val event: EventFieldDsl
    get() = EventFieldDsl(fieldWithId(EventNetworkField.EVENT))

  /**
   *  Query for the "url" field of the [EventNetwork] Igdb entity.
   *
   *  The value will be returned in the [EventNetwork.url] field of the response
   */
  public val url: IgdbRequestField<EventNetwork>
    get() = fieldWithId(EventNetworkField.URL)

  /**
   *  Fields of the "network_type" ([NetworkType][ru.pixnews.igdbclient.model.NetworkType]) nested
   * IGDB entity
   */
  public val network_type: NetworkTypeFieldDsl
    get() = NetworkTypeFieldDsl(fieldWithId(EventNetworkField.NETWORK_TYPE))

  /**
   *  Query for the "created_at" field of the [EventNetwork] Igdb entity.
   *
   *  The value will be returned in the [EventNetwork.created_at] field of the response
   */
  public val created_at: IgdbRequestField<EventNetwork>
    get() = fieldWithId(EventNetworkField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [EventNetwork] Igdb entity.
   *
   *  The value will be returned in the [EventNetwork.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<EventNetwork>
    get() = fieldWithId(EventNetworkField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [EventNetwork] Igdb entity.
   *
   *  The value will be returned in the [EventNetwork.checksum] field of the response
   */
  public val checksum: IgdbRequestField<EventNetwork>
    get() = fieldWithId(EventNetworkField.CHECKSUM)
}
