package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.GameMode
import ru.pixnews.igdbclient.scheme.`field`.GameModeField

private val _gameModeFieldDslInstance: GameModeFieldDsl = GameModeFieldDsl()

public val GameMode.Companion.`field`: GameModeFieldDsl
  get() = _gameModeFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [GameMode] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-mode](https://api-docs.igdb.com/#game-mode)
 */
@IgdbClientDsl
public class GameModeFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<GameModeField, GameMode>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [GameMode] Igdb entity.
   *
   *  The value will be returned in the [GameMode.id] field of the response
   */
  public val id: IgdbRequestField<GameMode>
    get() = fieldWithId(GameModeField.ID)

  /**
   *  Query for the "created_at" field of the [GameMode] Igdb entity.
   *
   *  The value will be returned in the [GameMode.created_at] field of the response
   */
  public val created_at: IgdbRequestField<GameMode>
    get() = fieldWithId(GameModeField.CREATED_AT)

  /**
   *  Query for the "name" field of the [GameMode] Igdb entity.
   *
   *  The value will be returned in the [GameMode.name] field of the response
   */
  public val name: IgdbRequestField<GameMode>
    get() = fieldWithId(GameModeField.NAME)

  /**
   *  Query for the "slug" field of the [GameMode] Igdb entity.
   *
   *  The value will be returned in the [GameMode.slug] field of the response
   */
  public val slug: IgdbRequestField<GameMode>
    get() = fieldWithId(GameModeField.SLUG)

  /**
   *  Query for the "updated_at" field of the [GameMode] Igdb entity.
   *
   *  The value will be returned in the [GameMode.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<GameMode>
    get() = fieldWithId(GameModeField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [GameMode] Igdb entity.
   *
   *  The value will be returned in the [GameMode.url] field of the response
   */
  public val url: IgdbRequestField<GameMode>
    get() = fieldWithId(GameModeField.URL)

  /**
   *  Query for the "checksum" field of the [GameMode] Igdb entity.
   *
   *  The value will be returned in the [GameMode.checksum] field of the response
   */
  public val checksum: IgdbRequestField<GameMode>
    get() = fieldWithId(GameModeField.CHECKSUM)
}
