package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.PlatformVersionCompany
import ru.pixnews.igdbclient.scheme.`field`.PlatformVersionCompanyField

private val _platformVersionCompanyFieldDslInstance: PlatformVersionCompanyFieldDsl =
    PlatformVersionCompanyFieldDsl()

public val PlatformVersionCompany.Companion.`field`: PlatformVersionCompanyFieldDsl
  get() = _platformVersionCompanyFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [PlatformVersionCompany] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#platform-version-company](https://api-docs.igdb.com/#platform-version-company)
 */
@IgdbClientDsl
public class PlatformVersionCompanyFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<PlatformVersionCompanyField, PlatformVersionCompany>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [PlatformVersionCompany] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionCompany.id] field of the response
   */
  public val id: IgdbRequestField<PlatformVersionCompany>
    get() = fieldWithId(PlatformVersionCompanyField.ID)

  /**
   *  Query for the "comment" field of the [PlatformVersionCompany] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionCompany.comment] field of the response
   */
  public val comment: IgdbRequestField<PlatformVersionCompany>
    get() = fieldWithId(PlatformVersionCompanyField.COMMENT)

  /**
   *  Fields of the "company" ([Company][ru.pixnews.igdbclient.model.Company]) nested IGDB entity
   */
  public val company: CompanyFieldDsl
    get() = CompanyFieldDsl(fieldWithId(PlatformVersionCompanyField.COMPANY))

  /**
   *  Query for the "developer" field of the [PlatformVersionCompany] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionCompany.developer] field of the response
   */
  public val developer: IgdbRequestField<PlatformVersionCompany>
    get() = fieldWithId(PlatformVersionCompanyField.DEVELOPER)

  /**
   *  Query for the "manufacturer" field of the [PlatformVersionCompany] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionCompany.manufacturer] field of the response
   */
  public val manufacturer: IgdbRequestField<PlatformVersionCompany>
    get() = fieldWithId(PlatformVersionCompanyField.MANUFACTURER)

  /**
   *  Query for the "checksum" field of the [PlatformVersionCompany] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionCompany.checksum] field of the response
   */
  public val checksum: IgdbRequestField<PlatformVersionCompany>
    get() = fieldWithId(PlatformVersionCompanyField.CHECKSUM)
}
