package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.ReleaseDateStatus
import ru.pixnews.igdbclient.scheme.`field`.ReleaseDateStatusField

private val _releaseDateStatusFieldDslInstance: ReleaseDateStatusFieldDsl =
    ReleaseDateStatusFieldDsl()

public val ReleaseDateStatus.Companion.`field`: ReleaseDateStatusFieldDsl
  get() = _releaseDateStatusFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [ReleaseDateStatus] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#release-date-status](https://api-docs.igdb.com/#release-date-status)
 */
@IgdbClientDsl
public class ReleaseDateStatusFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<ReleaseDateStatusField, ReleaseDateStatus>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [ReleaseDateStatus] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDateStatus.id] field of the response
   */
  public val id: IgdbRequestField<ReleaseDateStatus>
    get() = fieldWithId(ReleaseDateStatusField.ID)

  /**
   *  Query for the "name" field of the [ReleaseDateStatus] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDateStatus.name] field of the response
   */
  public val name: IgdbRequestField<ReleaseDateStatus>
    get() = fieldWithId(ReleaseDateStatusField.NAME)

  /**
   *  Query for the "description" field of the [ReleaseDateStatus] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDateStatus.description] field of the response
   */
  public val description: IgdbRequestField<ReleaseDateStatus>
    get() = fieldWithId(ReleaseDateStatusField.DESCRIPTION)

  /**
   *  Query for the "created_at" field of the [ReleaseDateStatus] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDateStatus.created_at] field of the response
   */
  public val created_at: IgdbRequestField<ReleaseDateStatus>
    get() = fieldWithId(ReleaseDateStatusField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [ReleaseDateStatus] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDateStatus.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<ReleaseDateStatus>
    get() = fieldWithId(ReleaseDateStatusField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [ReleaseDateStatus] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDateStatus.checksum] field of the response
   */
  public val checksum: IgdbRequestField<ReleaseDateStatus>
    get() = fieldWithId(ReleaseDateStatusField.CHECKSUM)
}
