package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.CompanyWebsite
import ru.pixnews.igdbclient.scheme.`field`.CompanyWebsiteField

private val _companyWebsiteFieldDslInstance: CompanyWebsiteFieldDsl = CompanyWebsiteFieldDsl()

public val CompanyWebsite.Companion.`field`: CompanyWebsiteFieldDsl
  get() = _companyWebsiteFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [CompanyWebsite] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#company-website](https://api-docs.igdb.com/#company-website)
 */
@IgdbClientDsl
public class CompanyWebsiteFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CompanyWebsiteField, CompanyWebsite>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [CompanyWebsite] Igdb entity.
   *
   *  The value will be returned in the [CompanyWebsite.id] field of the response
   */
  public val id: IgdbRequestField<CompanyWebsite>
    get() = fieldWithId(CompanyWebsiteField.ID)

  /**
   *  Query for the "category" field of the [CompanyWebsite] Igdb entity.
   *
   *  The value will be returned in the [CompanyWebsite.category] field of the response
   */
  public val category: IgdbRequestField<CompanyWebsite>
    get() = fieldWithId(CompanyWebsiteField.CATEGORY)

  /**
   *  Query for the "trusted" field of the [CompanyWebsite] Igdb entity.
   *
   *  The value will be returned in the [CompanyWebsite.trusted] field of the response
   */
  public val trusted: IgdbRequestField<CompanyWebsite>
    get() = fieldWithId(CompanyWebsiteField.TRUSTED)

  /**
   *  Query for the "url" field of the [CompanyWebsite] Igdb entity.
   *
   *  The value will be returned in the [CompanyWebsite.url] field of the response
   */
  public val url: IgdbRequestField<CompanyWebsite>
    get() = fieldWithId(CompanyWebsiteField.URL)

  /**
   *  Query for the "checksum" field of the [CompanyWebsite] Igdb entity.
   *
   *  The value will be returned in the [CompanyWebsite.checksum] field of the response
   */
  public val checksum: IgdbRequestField<CompanyWebsite>
    get() = fieldWithId(CompanyWebsiteField.CHECKSUM)
}
