package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Event
import ru.pixnews.igdbclient.scheme.`field`.EventField

private val _eventFieldDslInstance: EventFieldDsl = EventFieldDsl()

public val Event.Companion.`field`: EventFieldDsl
  get() = _eventFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Event] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#event](https://api-docs.igdb.com/#event)
 */
@IgdbClientDsl
public class EventFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<EventField, Event>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.id] field of the response
   */
  public val id: IgdbRequestField<Event>
    get() = fieldWithId(EventField.ID)

  /**
   *  Query for the "name" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.name] field of the response
   */
  public val name: IgdbRequestField<Event>
    get() = fieldWithId(EventField.NAME)

  /**
   *  Query for the "description" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.description] field of the response
   */
  public val description: IgdbRequestField<Event>
    get() = fieldWithId(EventField.DESCRIPTION)

  /**
   *  Query for the "slug" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.slug] field of the response
   */
  public val slug: IgdbRequestField<Event>
    get() = fieldWithId(EventField.SLUG)

  /**
   *  Fields of the "event_logo" ([EventLogo][ru.pixnews.igdbclient.model.EventLogo]) nested IGDB
   * entity
   */
  public val event_logo: EventLogoFieldDsl
    get() = EventLogoFieldDsl(fieldWithId(EventField.EVENT_LOGO))

  /**
   *  Query for the "start_time" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.start_time] field of the response
   */
  public val start_time: IgdbRequestField<Event>
    get() = fieldWithId(EventField.START_TIME)

  /**
   *  Query for the "time_zone" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.time_zone] field of the response
   */
  public val time_zone: IgdbRequestField<Event>
    get() = fieldWithId(EventField.TIME_ZONE)

  /**
   *  Query for the "end_time" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.end_time] field of the response
   */
  public val end_time: IgdbRequestField<Event>
    get() = fieldWithId(EventField.END_TIME)

  /**
   *  Query for the "live_stream_url" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.live_stream_url] field of the response
   */
  public val live_stream_url: IgdbRequestField<Event>
    get() = fieldWithId(EventField.LIVE_STREAM_URL)

  /**
   *  Fields of the "games" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val games: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(EventField.GAMES))

  /**
   *  Fields of the "videos" ([GameVideo][ru.pixnews.igdbclient.model.GameVideo]) nested IGDB entity
   */
  public val videos: GameVideoFieldDsl
    get() = GameVideoFieldDsl(fieldWithId(EventField.VIDEOS))

  /**
   *  Fields of the "event_networks" ([EventNetwork][ru.pixnews.igdbclient.model.EventNetwork])
   * nested IGDB entity
   */
  public val event_networks: EventNetworkFieldDsl
    get() = EventNetworkFieldDsl(fieldWithId(EventField.EVENT_NETWORKS))

  /**
   *  Query for the "created_at" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Event>
    get() = fieldWithId(EventField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Event>
    get() = fieldWithId(EventField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [Event] Igdb entity.
   *
   *  The value will be returned in the [Event.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Event>
    get() = fieldWithId(EventField.CHECKSUM)
}
