package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Keyword
import ru.pixnews.igdbclient.scheme.`field`.KeywordField

private val _keywordFieldDslInstance: KeywordFieldDsl = KeywordFieldDsl()

public val Keyword.Companion.`field`: KeywordFieldDsl
  get() = _keywordFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Keyword] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#keyword](https://api-docs.igdb.com/#keyword)
 */
@IgdbClientDsl
public class KeywordFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<KeywordField, Keyword>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Keyword] Igdb entity.
   *
   *  The value will be returned in the [Keyword.id] field of the response
   */
  public val id: IgdbRequestField<Keyword>
    get() = fieldWithId(KeywordField.ID)

  /**
   *  Query for the "created_at" field of the [Keyword] Igdb entity.
   *
   *  The value will be returned in the [Keyword.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Keyword>
    get() = fieldWithId(KeywordField.CREATED_AT)

  /**
   *  Query for the "name" field of the [Keyword] Igdb entity.
   *
   *  The value will be returned in the [Keyword.name] field of the response
   */
  public val name: IgdbRequestField<Keyword>
    get() = fieldWithId(KeywordField.NAME)

  /**
   *  Query for the "slug" field of the [Keyword] Igdb entity.
   *
   *  The value will be returned in the [Keyword.slug] field of the response
   */
  public val slug: IgdbRequestField<Keyword>
    get() = fieldWithId(KeywordField.SLUG)

  /**
   *  Query for the "updated_at" field of the [Keyword] Igdb entity.
   *
   *  The value will be returned in the [Keyword.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Keyword>
    get() = fieldWithId(KeywordField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [Keyword] Igdb entity.
   *
   *  The value will be returned in the [Keyword.url] field of the response
   */
  public val url: IgdbRequestField<Keyword>
    get() = fieldWithId(KeywordField.URL)

  /**
   *  Query for the "checksum" field of the [Keyword] Igdb entity.
   *
   *  The value will be returned in the [Keyword.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Keyword>
    get() = fieldWithId(KeywordField.CHECKSUM)
}
