package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.GameVersionFeatureValue

/**
 *  Fields of the [GameVersionFeatureValue] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#game-version-feature-value](https://api-docs.igdb.com/#game-version-feature-value)
 */
public enum class GameVersionFeatureValueField(
  public override val igdbName: String,
) : IgdbField<GameVersionFeatureValue> {
  /**
   *  Field "id" of the [GameVersionFeatureValue] IGDB entity. Matches [GameVersionFeatureValue.id].
   */
  ID("id"),
  /**
   *  Field "game" of the [GameVersionFeatureValue] IGDB entity. Matches
   * [GameVersionFeatureValue.game].
   */
  GAME("game"),
  /**
   *  Field "game_feature" of the [GameVersionFeatureValue] IGDB entity. Matches
   * [GameVersionFeatureValue.game_feature].
   */
  GAME_FEATURE("game_feature"),
  /**
   *  Field "included_feature" of the [GameVersionFeatureValue] IGDB entity. Matches
   * [GameVersionFeatureValue.included_feature].
   */
  INCLUDED_FEATURE("included_feature"),
  /**
   *  Field "note" of the [GameVersionFeatureValue] IGDB entity. Matches
   * [GameVersionFeatureValue.note].
   */
  NOTE("note"),
  /**
   *  Field "checksum" of the [GameVersionFeatureValue] IGDB entity. Matches
   * [GameVersionFeatureValue.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
