package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.LanguageSupportType

/**
 *  Fields of the [LanguageSupportType] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#language-support-type](https://api-docs.igdb.com/#language-support-type)
 */
public enum class LanguageSupportTypeField(
  public override val igdbName: String,
) : IgdbField<LanguageSupportType> {
  /**
   *  Field "id" of the [LanguageSupportType] IGDB entity. Matches [LanguageSupportType.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [LanguageSupportType] IGDB entity. Matches [LanguageSupportType.name].
   */
  NAME("name"),
  /**
   *  Field "created_at" of the [LanguageSupportType] IGDB entity. Matches
   * [LanguageSupportType.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [LanguageSupportType] IGDB entity. Matches
   * [LanguageSupportType.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [LanguageSupportType] IGDB entity. Matches
   * [LanguageSupportType.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
