package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.InvolvedCompany
import ru.pixnews.igdbclient.scheme.`field`.InvolvedCompanyField

private val _involvedCompanyFieldDslInstance: InvolvedCompanyFieldDsl = InvolvedCompanyFieldDsl()

public val InvolvedCompany.Companion.`field`: InvolvedCompanyFieldDsl
  get() = _involvedCompanyFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [InvolvedCompany] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#involved-company](https://api-docs.igdb.com/#involved-company)
 */
@IgdbClientDsl
public class InvolvedCompanyFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<InvolvedCompanyField, InvolvedCompany>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [InvolvedCompany] Igdb entity.
   *
   *  The value will be returned in the [InvolvedCompany.id] field of the response
   */
  public val id: IgdbRequestField<InvolvedCompany>
    get() = fieldWithId(InvolvedCompanyField.ID)

  /**
   *  Fields of the "company" ([Company][ru.pixnews.igdbclient.model.Company]) nested IGDB entity
   */
  public val company: CompanyFieldDsl
    get() = CompanyFieldDsl(fieldWithId(InvolvedCompanyField.COMPANY))

  /**
   *  Query for the "created_at" field of the [InvolvedCompany] Igdb entity.
   *
   *  The value will be returned in the [InvolvedCompany.created_at] field of the response
   */
  public val created_at: IgdbRequestField<InvolvedCompany>
    get() = fieldWithId(InvolvedCompanyField.CREATED_AT)

  /**
   *  Query for the "developer" field of the [InvolvedCompany] Igdb entity.
   *
   *  The value will be returned in the [InvolvedCompany.developer] field of the response
   */
  public val developer: IgdbRequestField<InvolvedCompany>
    get() = fieldWithId(InvolvedCompanyField.DEVELOPER)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(InvolvedCompanyField.GAME))

  /**
   *  Query for the "porting" field of the [InvolvedCompany] Igdb entity.
   *
   *  The value will be returned in the [InvolvedCompany.porting] field of the response
   */
  public val porting: IgdbRequestField<InvolvedCompany>
    get() = fieldWithId(InvolvedCompanyField.PORTING)

  /**
   *  Query for the "publisher" field of the [InvolvedCompany] Igdb entity.
   *
   *  The value will be returned in the [InvolvedCompany.publisher] field of the response
   */
  public val publisher: IgdbRequestField<InvolvedCompany>
    get() = fieldWithId(InvolvedCompanyField.PUBLISHER)

  /**
   *  Query for the "supporting" field of the [InvolvedCompany] Igdb entity.
   *
   *  The value will be returned in the [InvolvedCompany.supporting] field of the response
   */
  public val supporting: IgdbRequestField<InvolvedCompany>
    get() = fieldWithId(InvolvedCompanyField.SUPPORTING)

  /**
   *  Query for the "updated_at" field of the [InvolvedCompany] Igdb entity.
   *
   *  The value will be returned in the [InvolvedCompany.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<InvolvedCompany>
    get() = fieldWithId(InvolvedCompanyField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [InvolvedCompany] Igdb entity.
   *
   *  The value will be returned in the [InvolvedCompany.checksum] field of the response
   */
  public val checksum: IgdbRequestField<InvolvedCompany>
    get() = fieldWithId(InvolvedCompanyField.CHECKSUM)
}
