package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Search
import ru.pixnews.igdbclient.scheme.`field`.SearchField

private val _searchFieldDslInstance: SearchFieldDsl = SearchFieldDsl()

public val Search.Companion.`field`: SearchFieldDsl
  get() = _searchFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Search] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#search](https://api-docs.igdb.com/#search)
 */
@IgdbClientDsl
public class SearchFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<SearchField, Search>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Search] Igdb entity.
   *
   *  The value will be returned in the [Search.id] field of the response
   */
  public val id: IgdbRequestField<Search>
    get() = fieldWithId(SearchField.ID)

  /**
   *  Query for the "alternative_name" field of the [Search] Igdb entity.
   *
   *  The value will be returned in the [Search.alternative_name] field of the response
   */
  public val alternative_name: IgdbRequestField<Search>
    get() = fieldWithId(SearchField.ALTERNATIVE_NAME)

  /**
   *  Fields of the "character" ([Character][ru.pixnews.igdbclient.model.Character]) nested IGDB
   * entity
   */
  public val character: CharacterFieldDsl
    get() = CharacterFieldDsl(fieldWithId(SearchField.CHARACTER))

  /**
   *  Fields of the "collection" ([Collection][ru.pixnews.igdbclient.model.Collection]) nested IGDB
   * entity
   */
  public val collection: CollectionFieldDsl
    get() = CollectionFieldDsl(fieldWithId(SearchField.COLLECTION))

  /**
   *  Fields of the "company" ([Company][ru.pixnews.igdbclient.model.Company]) nested IGDB entity
   */
  public val company: CompanyFieldDsl
    get() = CompanyFieldDsl(fieldWithId(SearchField.COMPANY))

  /**
   *  Query for the "description" field of the [Search] Igdb entity.
   *
   *  The value will be returned in the [Search.description] field of the response
   */
  public val description: IgdbRequestField<Search>
    get() = fieldWithId(SearchField.DESCRIPTION)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(SearchField.GAME))

  /**
   *  Query for the "name" field of the [Search] Igdb entity.
   *
   *  The value will be returned in the [Search.name] field of the response
   */
  public val name: IgdbRequestField<Search>
    get() = fieldWithId(SearchField.NAME)

  /**
   *  Fields of the "platform" ([Platform][ru.pixnews.igdbclient.model.Platform]) nested IGDB entity
   */
  public val platform: PlatformFieldDsl
    get() = PlatformFieldDsl(fieldWithId(SearchField.PLATFORM))

  /**
   *  Query for the "published_at" field of the [Search] Igdb entity.
   *
   *  The value will be returned in the [Search.published_at] field of the response
   */
  public val published_at: IgdbRequestField<Search>
    get() = fieldWithId(SearchField.PUBLISHED_AT)

  /**
   *  Fields of the "test_dummy" ([TestDummy][ru.pixnews.igdbclient.model.TestDummy]) nested IGDB
   * entity
   */
  public val test_dummy: TestDummyFieldDsl
    get() = TestDummyFieldDsl(fieldWithId(SearchField.TEST_DUMMY))

  /**
   *  Fields of the "theme" ([Theme][ru.pixnews.igdbclient.model.Theme]) nested IGDB entity
   */
  public val theme: ThemeFieldDsl
    get() = ThemeFieldDsl(fieldWithId(SearchField.THEME))

  /**
   *  Query for the "checksum" field of the [Search] Igdb entity.
   *
   *  The value will be returned in the [Search.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Search>
    get() = fieldWithId(SearchField.CHECKSUM)
}
