package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.EventLogo

/**
 *  Fields of the [EventLogo] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#event-logo](https://api-docs.igdb.com/#event-logo)
 */
public enum class EventLogoField(
  public override val igdbName: String,
) : IgdbField<EventLogo> {
  /**
   *  Field "id" of the [EventLogo] IGDB entity. Matches [EventLogo.id].
   */
  ID("id"),
  /**
   *  Field "event" of the [EventLogo] IGDB entity. Matches [EventLogo.event].
   */
  EVENT("event"),
  /**
   *  Field "alpha_channel" of the [EventLogo] IGDB entity. Matches [EventLogo.alpha_channel].
   */
  ALPHA_CHANNEL("alpha_channel"),
  /**
   *  Field "animated" of the [EventLogo] IGDB entity. Matches [EventLogo.animated].
   */
  ANIMATED("animated"),
  /**
   *  Field "height" of the [EventLogo] IGDB entity. Matches [EventLogo.height].
   */
  HEIGHT("height"),
  /**
   *  Field "image_id" of the [EventLogo] IGDB entity. Matches [EventLogo.image_id].
   */
  IMAGE_ID("image_id"),
  /**
   *  Field "url" of the [EventLogo] IGDB entity. Matches [EventLogo.url].
   */
  URL("url"),
  /**
   *  Field "width" of the [EventLogo] IGDB entity. Matches [EventLogo.width].
   */
  WIDTH("width"),
  /**
   *  Field "created_at" of the [EventLogo] IGDB entity. Matches [EventLogo.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [EventLogo] IGDB entity. Matches [EventLogo.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [EventLogo] IGDB entity. Matches [EventLogo.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
